/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/generated/java_imodule.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_IModule(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/IModule");

        LookupJavaMethod(jEnv, info, "getState", "()Ltv/twitch/ModuleState;"); // public abstract tv.twitch.ModuleState getState();
        LookupJavaMethod(jEnv, info, "getModuleName", "()Ljava/lang/String;"); // public abstract java.lang.String getModuleName();
        LookupJavaMethod(jEnv, info, "initialize", "(Ltv/twitch/IModule$InitializeCallback;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode initialize(tv.twitch.IModule$InitializeCallback);
        LookupJavaMethod(jEnv, info, "update", "()Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode update();
        LookupJavaMethod(jEnv, info, "shutdown", "(Ltv/twitch/IModule$ShutdownCallback;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode shutdown(tv.twitch.IModule$ShutdownCallback);
    }

    return info;
}
