/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/generated/java_profileimage.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ProfileImage(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/ProfileImage");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.ProfileImage();

        LookupJavaField(jEnv, info, "url", "Ljava/lang/String;"); // public java.lang.String url;
        LookupJavaField(jEnv, info, "format", "Ljava/lang/String;"); // public java.lang.String format;
        LookupJavaField(jEnv, info, "width", "I"); // public int width;
        LookupJavaField(jEnv, info, "height", "I"); // public int height;
    }

    return info;
}
