/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/generated/java_squadinfo.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_SquadInfo(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/SquadInfo");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.SquadInfo();

        LookupJavaField(jEnv, info, "members", "[Ltv/twitch/SquadMember;"); // public tv.twitch.SquadMember[] members;
        LookupJavaField(jEnv, info, "squadId", "Ljava/lang/String;"); // public java.lang.String squadId;
        LookupJavaField(jEnv, info, "ownerId", "I"); // public int ownerId;
        LookupJavaField(jEnv, info, "status", "Ltv/twitch/SquadStatus;"); // public tv.twitch.SquadStatus status;
    }

    return info;
}
