/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/generated/java_squadmember.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_SquadMember(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/SquadMember");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.SquadMember();

        LookupJavaField(jEnv, info, "userLogin", "Ljava/lang/String;"); // public java.lang.String userLogin;
        LookupJavaField(jEnv, info, "userDisplayName", "Ljava/lang/String;"); // public java.lang.String userDisplayName;
        LookupJavaField(jEnv, info, "profileImageUrl150", "Ljava/lang/String;"); // public java.lang.String profileImageUrl150;
        LookupJavaField(jEnv, info, "channelId", "I"); // public int channelId;
    }

    return info;
}
