/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/generated/java_streaminfo.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_StreamInfo(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/StreamInfo");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.StreamInfo();

        LookupJavaField(jEnv, info, "channelInfo", "Ltv/twitch/ChannelInfo;"); // public tv.twitch.ChannelInfo channelInfo;
        LookupJavaField(jEnv, info, "previewImages", "Ltv/twitch/PreviewImages;"); // public tv.twitch.PreviewImages previewImages;
        LookupJavaField(jEnv, info, "game", "Ljava/lang/String;"); // public java.lang.String game;
        LookupJavaField(jEnv, info, "averageFPS", "D"); // public double averageFPS;
        LookupJavaField(jEnv, info, "streamId", "J"); // public long streamId;
        LookupJavaField(jEnv, info, "archiveVideoId", "J"); // public long archiveVideoId;
        LookupJavaField(jEnv, info, "delay", "J"); // public long delay;
        LookupJavaField(jEnv, info, "viewerCount", "J"); // public long viewerCount;
        LookupJavaField(jEnv, info, "videoHeight", "I"); // public int videoHeight;
        LookupJavaField(jEnv, info, "createdAtTimestamp", "I"); // public int createdAtTimestamp;
        LookupJavaField(jEnv, info, "broadcastPlatform", "Ltv/twitch/BroadcastPlatform;"); // public tv.twitch.BroadcastPlatform broadcastPlatform;
        LookupJavaField(jEnv, info, "streamType", "Ltv/twitch/StreamType;"); // public tv.twitch.StreamType streamType;
        LookupJavaField(jEnv, info, "isPlaylist", "Z"); // public boolean isPlaylist;
    }

    return info;
}
