/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/generated/java_streaminfoupdate.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_StreamInfoUpdate(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/StreamInfoUpdate");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.StreamInfoUpdate();

        LookupJavaField(jEnv, info, "title", "Ljava/lang/String;"); // public java.lang.String title;
        LookupJavaField(jEnv, info, "game", "Ljava/lang/String;"); // public java.lang.String game;
        LookupJavaField(jEnv, info, "gameId", "I"); // public int gameId;
    }

    return info;
}
