/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/generated/java_userinfo.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_UserInfo(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/UserInfo");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.UserInfo();

        LookupJavaMethod(jEnv, info, "createdDateFromTimestamp", "()Ljava/util/Date;"); // public java.util.Date createdDateFromTimestamp();

        LookupJavaField(jEnv, info, "userId", "I"); // public int userId;
        LookupJavaField(jEnv, info, "createdTimestamp", "I"); // public int createdTimestamp;
        LookupJavaField(jEnv, info, "userName", "Ljava/lang/String;"); // public java.lang.String userName;
        LookupJavaField(jEnv, info, "displayName", "Ljava/lang/String;"); // public java.lang.String displayName;
        LookupJavaField(jEnv, info, "bio", "Ljava/lang/String;"); // public java.lang.String bio;
        LookupJavaField(jEnv, info, "logoImageUrl", "Ljava/lang/String;"); // public java.lang.String logoImageUrl;
    }

    return info;
}
