/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/generated/java_watchpartyupdate.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_WatchPartyUpdate(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/WatchPartyUpdate");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.WatchPartyUpdate();

        LookupJavaField(jEnv, info, "incrementUrl", "Ljava/lang/String;"); // public java.lang.String incrementUrl;
        LookupJavaField(jEnv, info, "vodId", "Ljava/lang/String;"); // public java.lang.String vodId;
        LookupJavaField(jEnv, info, "title", "Ljava/lang/String;"); // public java.lang.String title;
        LookupJavaField(jEnv, info, "watchPartyId", "Ljava/lang/String;"); // public java.lang.String watchPartyId;
        LookupJavaField(jEnv, info, "broadcastType", "Ltv/twitch/VodType;"); // public tv.twitch.VodType broadcastType;
        LookupJavaField(jEnv, info, "viewable", "Z"); // public boolean viewable;
    }

    return info;
}
