/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

#include "twitchsdk/core/java_channellistenerproxy.h"

#include "twitchsdk/core/generated/java_all.h"
#include "twitchsdk/core/generated/jni_all.h"
#include "twitchsdk/core/java_coreutil.h"

ttv::binding::java::JavaChannelListenerProxy::JavaChannelListenerProxy() {
  mListenerInfo = GetJavaClassInfo_IChannelListener(gActiveJavaEnvironment);
}

void ttv::binding::java::JavaChannelListenerProxy::StreamUp(uint32_t playDelaySeconds) {
  auto jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  gActiveJavaEnvironment->CallVoidMethod(
    jListener, mListenerInfo.methods["streamUp"], static_cast<jint>(playDelaySeconds));
}

void ttv::binding::java::JavaChannelListenerProxy::StreamDown() {
  auto jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["streamDown"]);
}

void ttv::binding::java::JavaChannelListenerProxy::StreamViewerCountChanged(uint32_t viewerCount) {
  auto jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  gActiveJavaEnvironment->CallVoidMethod(
    jListener, mListenerInfo.methods["streamViewerCountChanged"], static_cast<jint>(viewerCount));
}

void ttv::binding::java::JavaChannelListenerProxy::StreamTriggeredMidroll(uint32_t durationSeconds) {
  auto jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  gActiveJavaEnvironment->CallVoidMethod(
    jListener, mListenerInfo.methods["streamTriggeredMidroll"], static_cast<jint>(durationSeconds));
}

void ttv::binding::java::JavaChannelListenerProxy::StreamReceivedWatchPartyUpdate(const WatchPartyUpdate& update) {
  auto jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jUpdate, GetJavaInstance_WatchPartyUpdate(gActiveJavaEnvironment, update));

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["streamReceivedWatchPartyUpdate"], jUpdate);
}

void ttv::binding::java::JavaChannelListenerProxy::ProfileImageUpdated(const std::vector<ProfileImage>& images) {
  auto jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  auto& info = GetJavaClassInfo_ProfileImage(gActiveJavaEnvironment);
  AUTO_DELETE_LOCAL_REF(gActiveJavaEnvironment, jobject, jImages,
    GetJavaInstance_Array(gActiveJavaEnvironment, info, static_cast<uint32_t>(images.size()),
      [&images](uint32_t index) { return GetJavaInstance_ProfileImage(gActiveJavaEnvironment, images[index]); }));
  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["profileImageUpdated"], jImages);
}

void ttv::binding::java::JavaChannelListenerProxy::StreamInfoUpdated(StreamInfoUpdate&& info) {
  auto jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jInfo, GetJavaInstance_StreamInfoUpdate(gActiveJavaEnvironment, info));

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["streamInfoUpdated"], jInfo);
}

void ttv::binding::java::JavaChannelListenerProxy::SquadUpdated(SquadInfo&& squad) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jstring, jSquad, GetJavaInstance_SquadInfo(gActiveJavaEnvironment, squad));

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["squadUpdated"], jSquad);
}

void ttv::binding::java::JavaChannelListenerProxy::SquadLeft() {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["squadLeft"]);
}

void ttv::binding::java::JavaChannelListenerProxy::PixelTrackingUpdate(bool refresh) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jBoolean, GetJavaInstance_Boolean(gActiveJavaEnvironment, refresh));
  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["pixelTrackingUpdate"], jBoolean);
}
