/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

#include "twitchsdk/core/java_coreapilistenerproxy.h"

#include "twitchsdk/core/generated/java_all.h"
#include "twitchsdk/core/generated/jni_all.h"
#include "twitchsdk/core/java_coreutil.h"
#include "twitchsdk/core/java_utility.h"

ttv::binding::java::JavaCoreAPIListenerProxy::JavaCoreAPIListenerProxy(jobject jModule)
    : NativeModuleListener(jModule) {
  mListenerInfo = GetJavaClassInfo_ICoreAPIListener(gActiveJavaEnvironment);
}

void ttv::binding::java::JavaCoreAPIListenerProxy::CoreUserLoginComplete(
  const std::string& oauthToken, UserId userId, const ErrorDetails& errorDetails) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  // Notify the java client
  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jOAuthToken, GetJavaInstance_String(gActiveJavaEnvironment, oauthToken));
  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jResult, GetJavaInstance_ErrorCode(gActiveJavaEnvironment, errorDetails.ec));

  gActiveJavaEnvironment->CallVoidMethod(
    jListener, mListenerInfo.methods["coreUserLoginComplete"], jOAuthToken, userId, jResult);
}

void ttv::binding::java::JavaCoreAPIListenerProxy::CoreUserLogoutComplete(UserId userId, TTV_ErrorCode ec) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  // Notify the java client
  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jResult, GetJavaInstance_ErrorCode(gActiveJavaEnvironment, ec));

  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["coreUserLogoutComplete"], userId, jResult);
}

void ttv::binding::java::JavaCoreAPIListenerProxy::CoreUserAuthenticationIssue(
  UserId userId, const std::string& oauthToken, const ErrorDetails& errorDetails) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  // Notify the java client
  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jOAuthToken, GetJavaInstance_String(gActiveJavaEnvironment, oauthToken));
  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jErrorCode, GetJavaInstance_ErrorCode(gActiveJavaEnvironment, errorDetails.ec));

  gActiveJavaEnvironment->CallVoidMethod(
    jListener, mListenerInfo.methods["coreUserAuthenticationIssue"], userId, jOAuthToken, jErrorCode);
}

void ttv::binding::java::JavaCoreAPIListenerProxy::CorePubSubStateChanged(
  UserId userId, PubSubState state, TTV_ErrorCode ec) {
  jobject jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  // Notify the java client
  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jState, GetJavaInstance_PubSubState(gActiveJavaEnvironment, state));
  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jErrorCode, GetJavaInstance_ErrorCode(gActiveJavaEnvironment, ec));

  gActiveJavaEnvironment->CallVoidMethod(
    jListener, mListenerInfo.methods["corePubSubStateChanged"], userId, jState, jErrorCode);
}
