/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

#include "twitchsdk/core/java_dashboardactivitylistenerproxy.h"

#include "twitchsdk/core/generated/java_all.h"
#include "twitchsdk/core/generated/jni_all.h"
#include "twitchsdk/core/java_coreutil.h"

ttv::binding::java::JavaDashboardActivityListenerProxy::JavaDashboardActivityListenerProxy() {
  mListenerInfo = GetJavaClassInfo_IDashboardActivityListener(gActiveJavaEnvironment);
}

void ttv::binding::java::JavaDashboardActivityListenerProxy::EventBitsUseage(const DashboardActivityBitsUsage& data) {
  auto jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jUpdate, GetJavaInstance_DashboardActivityBitsUsage(gActiveJavaEnvironment, data));
  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["eventBitsUseage"], jUpdate);
}

void ttv::binding::java::JavaDashboardActivityListenerProxy::EventFollower(const DashboardActivityFollow& data) {
  auto jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jUpdate, GetJavaInstance_DashboardActivityFollow(gActiveJavaEnvironment, data));
  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["eventFollower"], jUpdate);
}

void ttv::binding::java::JavaDashboardActivityListenerProxy::EventAutoHostStart(const DashboardActivityHost& data) {
  auto jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jUpdate, GetJavaInstance_DashboardActivityHost(gActiveJavaEnvironment, data));
  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["eventAutoHostStart"], jUpdate);
}

void ttv::binding::java::JavaDashboardActivityListenerProxy::EventHostStart(const DashboardActivityHost& data) {
  auto jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jUpdate, GetJavaInstance_DashboardActivityHost(gActiveJavaEnvironment, data));
  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["eventHostStart"], jUpdate);
}

void ttv::binding::java::JavaDashboardActivityListenerProxy::EventRaiding(const DashboardActivityRaiding& data) {
  auto jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jUpdate, GetJavaInstance_DashboardActivityRaiding(gActiveJavaEnvironment, data));
  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["eventRaiding"], jUpdate);
}

void ttv::binding::java::JavaDashboardActivityListenerProxy::EventSubscription(
  const DashboardActivitySubscription& data) {
  auto jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(gActiveJavaEnvironment, jobject, jUpdate,
    GetJavaInstance_DashboardActivitySubscription(gActiveJavaEnvironment, data));
  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["eventSubscription"], jUpdate);
}

void ttv::binding::java::JavaDashboardActivityListenerProxy::EventPrimeSubscription(
  const DashboardActivitySubscription& data) {
  auto jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(gActiveJavaEnvironment, jobject, jUpdate,
    GetJavaInstance_DashboardActivitySubscription(gActiveJavaEnvironment, data));
  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["eventPrimeSubscription"], jUpdate);
}

void ttv::binding::java::JavaDashboardActivityListenerProxy::EventResubscriptionSharing(
  const DashboardActivityResubscriptionSharing& data) {
  auto jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(gActiveJavaEnvironment, jobject, jUpdate,
    GetJavaInstance_DashboardActivityResubscriptionSharing(gActiveJavaEnvironment, data));
  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["eventResubscriptionSharing"], jUpdate);
}

void ttv::binding::java::JavaDashboardActivityListenerProxy::EventPrimeResubscriptionSharing(
  const DashboardActivityResubscriptionSharing& data) {
  auto jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(gActiveJavaEnvironment, jobject, jUpdate,
    GetJavaInstance_DashboardActivityResubscriptionSharing(gActiveJavaEnvironment, data));
  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["eventPrimeResubscriptionSharing"], jUpdate);
}

void ttv::binding::java::JavaDashboardActivityListenerProxy::EventSubscriptionGiftingCommunity(
  const DashboardActivitySubscriptionGiftingCommunity& data) {
  auto jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(gActiveJavaEnvironment, jobject, jUpdate,
    GetJavaInstance_DashboardActivitySubscriptionGiftingCommunity(gActiveJavaEnvironment, data));
  gActiveJavaEnvironment->CallVoidMethod(
    jListener, mListenerInfo.methods["eventSubscriptionGiftingCommunity"], jUpdate);
}

void ttv::binding::java::JavaDashboardActivityListenerProxy::EventSubscriptionGiftingIndividual(
  const DashboardActivitySubscriptionGiftingIndividual& data) {
  auto jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(gActiveJavaEnvironment, jobject, jUpdate,
    GetJavaInstance_DashboardActivitySubscriptionGiftingIndividual(gActiveJavaEnvironment, data));
  gActiveJavaEnvironment->CallVoidMethod(
    jListener, mListenerInfo.methods["eventSubscriptionGiftingIndividual"], jUpdate);
}

void ttv::binding::java::JavaDashboardActivityListenerProxy::EventStreamUp(const DashboardActivityHeader& data) {
  auto jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(
    gActiveJavaEnvironment, jobject, jUpdate, GetJavaInstance_DashboardActivityHeader(gActiveJavaEnvironment, data));
  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["eventStreamUp"], jUpdate);
}
