/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

#include "twitchsdk/core/java_eventtrackerproxy.h"

#include "twitchsdk/core/generated/java_all.h"
#include "twitchsdk/core/generated/jni_all.h"
#include "twitchsdk/core/java_coreutil.h"

ttv::binding::java::JavaEventTrackerProxy::JavaEventTrackerProxy() {
  AutoJEnv jEnv;
  mListenerInfo = GetJavaClassInfo_IEventTracker(jEnv);
}

TTV_ErrorCode ttv::binding::java::JavaEventTrackerProxy::TrackEvent(
  const std::string& eventName, const std::map<std::string, TrackingValue>& properties) {
  auto jEventTracker = mJavaListener.GetInstance();
  if (jEventTracker == nullptr) {
    return TTV_EC_INVALID_INSTANCE;
  }

  AutoJEnv jEnv;

  AUTO_DELETE_LOCAL_REF(jEnv, jobject, jEventName, GetJavaInstance_String(jEnv, eventName));
  AUTO_DELETE_LOCAL_REF(jEnv, jobject, jProperties,
    GetJavaInstance_HashMap(jEnv, properties, [&jEnv](const std::pair<std::string, TrackingValue>& pair) {
      jobject jKey = GetJavaInstance_String(jEnv, pair.first);
      jobject jValue = GetJavaInstance_TrackingValue(jEnv, pair.second);

      return std::pair<jobject, jobject>{jKey, jValue};
    }));

  jobject jError = jEnv->CallObjectMethod(jEventTracker, mListenerInfo.methods["trackEvent"], jEventName, jProperties);

  return static_cast<TTV_ErrorCode>(jEnv->CallIntMethod(jError, GetJavaClassInfo_ErrorCode(jEnv).methods["getValue"]));
}
