/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

#include "twitchsdk/core/generated/java_all.h"
#include "twitchsdk/core/generated/jni_all.h"
#include "twitchsdk/core/java_coreutil.h"
#include "twitchsdk/core/java_genericsubscriberlistenerproxy.h"

ttv::binding::java::JavaGenericSubscriberListenerProxy::JavaGenericSubscriberListenerProxy() {
  mListenerInfo = GetJavaClassInfo_IGenericSubscriberListener(gActiveJavaEnvironment);
}

void ttv::binding::java::JavaGenericSubscriberListenerProxy::EventTopicData(const std::string& data) {
  auto jListener = mJavaListener.GetInstance();
  if (jListener == nullptr) {
    return;
  }

  AUTO_DELETE_LOCAL_REF(gActiveJavaEnvironment, jstring, jData, GetJavaInstance_String(gActiveJavaEnvironment, data));
  gActiveJavaEnvironment->CallVoidMethod(jListener, mListenerInfo.methods["eventTopicData"], jData);
}
