/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

#include "twitchsdk/core/java_tracerproxy.h"

#include "twitchsdk/core/generated/java_all.h"
#include "twitchsdk/core/generated/jni_all.h"
#include "twitchsdk/core/java_coreutil.h"

ttv::binding::java::JavaTracerProxy::JavaTracerProxy() {
  AutoJEnv jEnv;
  mListenerInfo = GetJavaClassInfo_ITracer(jEnv);
}

void ttv::binding::java::JavaTracerProxy::Log(
  const char* component, const char* messageLevel, const char* format, va_list args) {
  auto jTracer = mJavaListener.GetInstance();
  if (jTracer == nullptr) {
    return;
  }

  AutoJEnv jEnv;

  if (mTraceFile != nullptr) {
    // Print the line prefix
    GetLinePrefix(component, messageLevel, &mPrintBuffer[0], mPrintBuffer.size());
    LogToFile(&mPrintBuffer[0]);
  }

  // Print the message
  vsnprintf(&mPrintBuffer[0], mPrintBuffer.size() - 1, format, args);
  mPrintBuffer[mPrintBuffer.size() - 1] = '\0';

  if (mTraceFile != nullptr) {
    LogToFile(&mPrintBuffer[0]);
  }

  AUTO_DELETE_LOCAL_REF(jEnv, jstring, jComponent, GetJavaInstance_String(jEnv, component));
  AUTO_DELETE_LOCAL_REF(jEnv, jstring, jMessageLevel, GetJavaInstance_String(jEnv, messageLevel));
  AUTO_DELETE_LOCAL_REF(jEnv, jstring, jLog, GetJavaInstance_String(jEnv, &mPrintBuffer[0]));

  jEnv->CallVoidMethod(jTracer, mListenerInfo.methods["log"], jComponent, jMessageLevel, jLog);
}
