/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

#include "twitchsdk/core/generated/jni_channelstatusproxy.h"

#include "twitchsdk/core/channel/ichannelstatus.h"
#include "twitchsdk/core/generated/java_ichannelstatus_uploadprofileimagecallback.h"
#include "twitchsdk/core/java_coreutil.h"

using namespace ttv;
using namespace ttv::binding::java;

#define GET_NATIVE_PTR(x) reinterpret_cast<IChannelStatus*>(x)

JNIEXPORT void JNICALL Java_tv_twitch_ChannelStatusProxy_DisposeNativeInstance(
  JNIEnv* /*jEnv*/, jobject jThis, jlong /*jNativeObjectPointer*/) {
  auto context = gIChannelStatusInstanceRegistry.LookupNativeContext(jThis);
  if (context == nullptr) {
    return;
  }

  auto instance = gIChannelStatusInstanceRegistry.LookupNativeInstance(jThis);
  if (instance == nullptr) {
    return;
  }

  TTV_ErrorCode ec = instance->Dispose();

  if (TTV_SUCCEEDED(ec)) {
    gIChannelStatusInstanceRegistry.Unregister(jThis);
  }
}

JNIEXPORT jobject JNICALL Java_tv_twitch_ChannelStatusProxy_UploadProfileImage(JNIEnv* jEnv, jobject /*jThis*/,
  jlong jNativeObjectPointer, jbyteArray jImageBuffer, jint jImageSize, jobject jCallback) {
  ScopedJavaEnvironmentCacher jEnvCacher(jEnv);

  IChannelStatus* channelStatus = GET_NATIVE_PTR(jNativeObjectPointer);

  auto callback = CreateJavaCallbackWrapper<jobject, jobjectArray>(
    jEnv, jCallback, GetJavaClassInfo_IChannelStatus_UploadProfileImageCallback(jEnv));

  jbyte* imageBuffer = jEnv->GetByteArrayElements(jImageBuffer, nullptr);

  TTV_ErrorCode ec = channelStatus->UploadProfileImage(reinterpret_cast<const char*>(imageBuffer),
    static_cast<size_t>(jImageSize), [callback](TTV_ErrorCode callbackEc, const std::vector<ProfileImage>& images) {
      AUTO_DELETE_LOCAL_REF(
        gActiveJavaEnvironment, jobject, jError, GetJavaInstance_ErrorCode(gActiveJavaEnvironment, callbackEc));
      AUTO_DELETE_LOCAL_REF(gActiveJavaEnvironment, jobjectArray, jImages,
        (TTV_SUCCEEDED(callbackEc) ? GetJavaInstance_ProfileImageArray(gActiveJavaEnvironment, images) : nullptr));

      callback(jError, jImages);
    });

  return GetJavaInstance_ErrorCode(jEnv, ec);
}
