/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

#include "twitchsdk/core/generated/jni_genericsubscriberstatusproxy.h"

#include "twitchsdk/core/igenericsubscriberstatus.h"
#include "twitchsdk/core/java_coreutil.h"

using namespace ttv;
using namespace ttv::binding::java;

#define GET_NATIVE_PTR(x) reinterpret_cast<IGenericSubscriberStatus*>(x)

JNIEXPORT void JNICALL Java_tv_twitch_GenericSubscriberStatusProxy_DisposeNativeInstance(
  JNIEnv* /*jEnv*/, jobject jThis, jlong /*jNativeObjectPointer*/) {
  auto context = gIGenericSubscriberStatusInstanceRegistry.LookupNativeContext(jThis);
  if (context == nullptr) {
    return;
  }

  auto instance = gIGenericSubscriberStatusInstanceRegistry.LookupNativeInstance(jThis);
  if (instance == nullptr) {
    return;
  }

  TTV_ErrorCode ec = instance->Dispose();

  if (TTV_SUCCEEDED(ec)) {
    gIGenericSubscriberStatusInstanceRegistry.Unregister(jThis);
  }
}
