package tv.twitch;

public class CoreErrorCode extends ErrorCode {
    public static void forceClassInit() {}

    // BINDING_ENUM_START (Do not remove this line, it's used by the bindings tools)
    public static final ErrorCode TTV_EC_SUCCESS = new CoreErrorCode(0x0, "TTV_EC_SUCCESS");
    public static final ErrorCode TTV_EC_BEGIN_ERRORS = new CoreErrorCode(0x1, "TTV_EC_BEGIN_ERRORS");
    public static final ErrorCode TTV_EC_UNKNOWN_ERROR = new CoreErrorCode(0x2, "TTV_EC_UNKNOWN_ERROR");
    public static final ErrorCode TTV_EC_CANNOT_OPEN_FILE = new CoreErrorCode(0x3, "TTV_EC_CANNOT_OPEN_FILE");
    public static final ErrorCode TTV_EC_NOTENOUGHDATA = new CoreErrorCode(0x4, "TTV_EC_NOTENOUGHDATA");
    public static final ErrorCode TTV_EC_MUTEX_NOT_ACQUIRED = new CoreErrorCode(0x5, "TTV_EC_MUTEX_NOT_ACQUIRED");
    public static final ErrorCode TTV_EC_CONDITION_WAIT_FAILED = new CoreErrorCode(0x6, "TTV_EC_CONDITION_WAIT_FAILED");
    public static final ErrorCode TTV_EC_WAIT_TIMEOUT = new CoreErrorCode(0x7, "TTV_EC_WAIT_TIMEOUT");
    public static final ErrorCode TTV_EC_OAUTH_SCOPES_MISSING = new CoreErrorCode(0x8, "TTV_EC_OAUTH_SCOPES_MISSING");
    public static final ErrorCode TTV_EC_ALREADY_INITIALIZED = new CoreErrorCode(0x9, "TTV_EC_ALREADY_INITIALIZED");
    public static final ErrorCode TTV_EC_CANNOT_WRITE_TO_FILE = new CoreErrorCode(0xa, "TTV_EC_CANNOT_WRITE_TO_FILE");
    public static final ErrorCode TTV_EC_CANNOT_CREATE_MUTEX = new CoreErrorCode(0xb, "TTV_EC_CANNOT_CREATE_MUTEX");
    public static final ErrorCode TTV_EC_CANNOT_DESTROY_MUTEX = new CoreErrorCode(0xc, "TTV_EC_CANNOT_DESTROY_MUTEX");
    public static final ErrorCode TTV_EC_COULD_NOT_TAKE_MUTEX = new CoreErrorCode(0xd, "TTV_EC_COULD_NOT_TAKE_MUTEX");
    public static final ErrorCode TTV_EC_COULD_NOT_RELEASE_MUTEX =
        new CoreErrorCode(0xe, "TTV_EC_COULD_NOT_RELEASE_MUTEX");
    public static final ErrorCode TTV_EC_INVALID_MUTEX = new CoreErrorCode(0xf, "TTV_EC_INVALID_MUTEX");
    public static final ErrorCode TTV_EC_INVALID_ARG = new CoreErrorCode(0x10, "TTV_EC_INVALID_ARG");
    public static final ErrorCode TTV_EC_INVALID_FORMAT = new CoreErrorCode(0x11, "TTV_EC_INVALID_FORMAT");
    public static final ErrorCode TTV_EC_NOT_INITIALIZED = new CoreErrorCode(0x12, "TTV_EC_NOT_INITIALIZED");
    public static final ErrorCode TTV_EC_AUTHENTICATION = new CoreErrorCode(0x13, "TTV_EC_AUTHENTICATION");
    public static final ErrorCode TTV_EC_FORBIDDEN = new CoreErrorCode(0x14, "TTV_EC_FORBIDDEN");
    public static final ErrorCode TTV_EC_INVALID_OAUTHTOKEN = new CoreErrorCode(0x15, "TTV_EC_INVALID_OAUTHTOKEN");
    public static final ErrorCode TTV_EC_USERINFO_NOT_AVAILABLE =
        new CoreErrorCode(0x16, "TTV_EC_USERINFO_NOT_AVAILABLE");
    public static final ErrorCode TTV_EC_NOT_AVAILABLE = new CoreErrorCode(0x17, "TTV_EC_NOT_AVAILABLE");
    public static final ErrorCode TTV_EC_PARAMETERS_CHANGED = new CoreErrorCode(0x18, "TTV_EC_PARAMETERS_CHANGED");
    public static final ErrorCode TTV_EC_MEMORY = new CoreErrorCode(0x19, "TTV_EC_MEMORY");
    public static final ErrorCode TTV_EC_ALIGN16_REQUIRED = new CoreErrorCode(0x1a, "TTV_EC_ALIGN16_REQUIRED");
    public static final ErrorCode TTV_EC_HTTPREQUEST_ERROR = new CoreErrorCode(0x1b, "TTV_EC_HTTPREQUEST_ERROR");
    public static final ErrorCode TTV_EC_RATE_LIMITED = new CoreErrorCode(0x1c, "TTV_EC_RATE_LIMITED");
    public static final ErrorCode TTV_EC_NO_FACTORIES_REGISTERED =
        new CoreErrorCode(0x1d, "TTV_EC_NO_FACTORIES_REGISTERED");
    public static final ErrorCode TTV_EC_INVALID_CLIENTID = new CoreErrorCode(0x1e, "TTV_EC_INVALID_CLIENTID");
    public static final ErrorCode TTV_EC_INVALID_CHANNEL_ID = new CoreErrorCode(0x1f, "TTV_EC_INVALID_CHANNEL_ID");
    public static final ErrorCode TTV_EC_OPERATION_FAILED = new CoreErrorCode(0x20, "TTV_EC_OPERATION_FAILED");
    public static final ErrorCode TTV_EC_API_REQUEST_FAILED = new CoreErrorCode(0x21, "TTV_EC_API_REQUEST_FAILED");
    public static final ErrorCode TTV_EC_API_REQUEST_TIMEDOUT = new CoreErrorCode(0x22, "TTV_EC_API_REQUEST_TIMEDOUT");
    public static final ErrorCode TTV_EC_INVALID_HTTP_REQUEST_PARAMS =
        new CoreErrorCode(0x23, "TTV_EC_INVALID_HTTP_REQUEST_PARAMS");
    public static final ErrorCode TTV_EC_COINITIALIZE_FAIED = new CoreErrorCode(0x24, "TTV_EC_COINITIALIZE_FAIED");
    public static final ErrorCode TTV_EC_WEBAPI_RESULT_INVALID_JSON =
        new CoreErrorCode(0x25, "TTV_EC_WEBAPI_RESULT_INVALID_JSON");
    public static final ErrorCode TTV_EC_WEBAPI_RESULT_NO_AUTHTOKEN =
        new CoreErrorCode(0x26, "TTV_EC_WEBAPI_RESULT_NO_AUTHTOKEN");
    public static final ErrorCode TTV_EC_WEBAPI_RESULT_NO_STREAMKEY =
        new CoreErrorCode(0x27, "TTV_EC_WEBAPI_RESULT_NO_STREAMKEY");
    public static final ErrorCode TTV_EC_WEBAPI_RESULT_NO_CHANNELNAME =
        new CoreErrorCode(0x28, "TTV_EC_WEBAPI_RESULT_NO_CHANNELNAME");
    public static final ErrorCode TTV_EC_WEBAPI_RESULT_NO_INGESTS =
        new CoreErrorCode(0x29, "TTV_EC_WEBAPI_RESULT_NO_INGESTS");
    public static final ErrorCode TTV_EC_WEBAPI_RESULT_NO_RECORDING_STATUS =
        new CoreErrorCode(0x2a, "TTV_EC_WEBAPI_RESULT_NO_RECORDING_STATUS");
    public static final ErrorCode TTV_EC_WEBAPI_RESULT_NO_STREAMINFO =
        new CoreErrorCode(0x2b, "TTV_EC_WEBAPI_RESULT_NO_STREAMINFO");
    public static final ErrorCode TTV_EC_WEBAPI_RESULT_INVALID_VIEWERS =
        new CoreErrorCode(0x2c, "TTV_EC_WEBAPI_RESULT_INVALID_VIEWERS");
    public static final ErrorCode TTV_EC_WEBAPI_RESULT_NO_USERNAME =
        new CoreErrorCode(0x2d, "TTV_EC_WEBAPI_RESULT_NO_USERNAME");
    public static final ErrorCode TTV_EC_WEBAPI_RESULT_NO_USER_DISPLAY_NAME =
        new CoreErrorCode(0x2e, "TTV_EC_WEBAPI_RESULT_NO_USER_DISPLAY_NAME");
    public static final ErrorCode TTV_EC_NEED_TO_LOGIN = new CoreErrorCode(0x2f, "TTV_EC_NEED_TO_LOGIN");
    public static final ErrorCode TTV_EC_INVALID_LOGIN = new CoreErrorCode(0x30, "TTV_EC_INVALID_LOGIN");
    public static final ErrorCode TTV_EC_BANNED_USER = new CoreErrorCode(0x31, "TTV_EC_BANNED_USER");
    public static final ErrorCode TTV_EC_INVALID_USERID = new CoreErrorCode(0x32, "TTV_EC_INVALID_USERID");
    public static final ErrorCode TTV_EC_INVALID_BUFFER = new CoreErrorCode(0x33, "TTV_EC_INVALID_BUFFER");
    public static final ErrorCode TTV_EC_INVALID_CALLBACK = new CoreErrorCode(0x34, "TTV_EC_INVALID_CALLBACK");
    public static final ErrorCode TTV_EC_INVALID_JSON = new CoreErrorCode(0x35, "TTV_EC_INVALID_JSON");
    public static final ErrorCode TTV_EC_INVALID_STATE = new CoreErrorCode(0x36, "TTV_EC_INVALID_STATE");
    public static final ErrorCode TTV_EC_CANNOT_SUSPEND_THREADSYNC =
        new CoreErrorCode(0x37, "TTV_EC_CANNOT_SUSPEND_THREADSYNC");
    public static final ErrorCode TTV_EC_CANNOT_SIGNAL_THREADSYNC =
        new CoreErrorCode(0x38, "TTV_EC_CANNOT_SIGNAL_THREADSYNC");
    public static final ErrorCode TTV_EC_REQUEST_TIMEDOUT = new CoreErrorCode(0x39, "TTV_EC_REQUEST_TIMEDOUT");
    public static final ErrorCode TTV_EC_REQUEST_PENDING = new CoreErrorCode(0x3a, "TTV_EC_REQUEST_PENDING");
    public static final ErrorCode TTV_EC_OS_TOO_OLD = new CoreErrorCode(0x3b, "TTV_EC_OS_TOO_OLD");
    public static final ErrorCode TTV_EC_SHUTTING_DOWN = new CoreErrorCode(0x3c, "TTV_EC_SHUTTING_DOWN");
    public static final ErrorCode TTV_EC_SHUT_DOWN = new CoreErrorCode(0x3d, "TTV_EC_SHUT_DOWN");
    public static final ErrorCode TTV_EC_UNIMPLEMENTED = new CoreErrorCode(0x3e, "TTV_EC_UNIMPLEMENTED");
    public static final ErrorCode TTV_EC_ALREADY_LOGGED_IN = new CoreErrorCode(0x3f, "TTV_EC_ALREADY_LOGGED_IN");
    public static final ErrorCode TTV_EC_ALREADY_CACHED = new CoreErrorCode(0x40, "TTV_EC_ALREADY_CACHED");
    public static final ErrorCode TTV_EC_FEATURE_DISABLED = new CoreErrorCode(0x41, "TTV_EC_FEATURE_DISABLED");
    public static final ErrorCode TTV_EC_UNSUPPORTED = new CoreErrorCode(0x42, "TTV_EC_UNSUPPORTED");
    public static final ErrorCode TTV_EC_INVALID_INSTANCE = new CoreErrorCode(0x43, "TTV_EC_INVALID_INSTANCE");
    public static final ErrorCode TTV_EC_SOCKET_EWOULDBLOCK = new CoreErrorCode(0x44, "TTV_EC_SOCKET_EWOULDBLOCK");
    public static final ErrorCode TTV_EC_SOCKET_ENOTCONN = new CoreErrorCode(0x45, "TTV_EC_SOCKET_ENOTCONN");
    public static final ErrorCode TTV_EC_SOCKET_TRY_AGAIN = new CoreErrorCode(0x46, "TTV_EC_SOCKET_TRY_AGAIN");
    public static final ErrorCode TTV_EC_SOCKET_CONNECT_FAILED =
        new CoreErrorCode(0x47, "TTV_EC_SOCKET_CONNECT_FAILED");
    public static final ErrorCode TTV_EC_SOCKET_ECONNABORTED = new CoreErrorCode(0x48, "TTV_EC_SOCKET_ECONNABORTED");
    public static final ErrorCode TTV_EC_SOCKET_EALREADY = new CoreErrorCode(0x49, "TTV_EC_SOCKET_EALREADY");
    public static final ErrorCode TTV_EC_SOCKET_CREATE_FAILED = new CoreErrorCode(0x4a, "TTV_EC_SOCKET_CREATE_FAILED");
    public static final ErrorCode TTV_EC_SOCKET_GETADDRINFO_FAILED =
        new CoreErrorCode(0x4b, "TTV_EC_SOCKET_GETADDRINFO_FAILED");
    public static final ErrorCode TTV_EC_SOCKET_HOST_NOT_FOUND =
        new CoreErrorCode(0x4c, "TTV_EC_SOCKET_HOST_NOT_FOUND");
    public static final ErrorCode TTV_EC_SOCKET_RECV_ERROR = new CoreErrorCode(0x4d, "TTV_EC_SOCKET_RECV_ERROR");
    public static final ErrorCode TTV_EC_SOCKET_SEND_ERROR = new CoreErrorCode(0x4e, "TTV_EC_SOCKET_SEND_ERROR");
    public static final ErrorCode TTV_EC_SOCKET_IOCTL_ERROR = new CoreErrorCode(0x4f, "TTV_EC_SOCKET_IOCTL_ERROR");
    public static final ErrorCode TTV_EC_SOCKET_ETIMEDOUT = new CoreErrorCode(0x50, "TTV_EC_SOCKET_ETIMEDOUT");
    public static final ErrorCode TTV_EC_SOCKET_ECONNRESET = new CoreErrorCode(0x51, "TTV_EC_SOCKET_ECONNRESET");
    public static final ErrorCode TTV_EC_SOCKET_ERR = new CoreErrorCode(0x52, "TTV_EC_SOCKET_ERR");
    public static final ErrorCode TTV_EC_PUBSUB_BAD_TOPIC = new CoreErrorCode(0x53, "TTV_EC_PUBSUB_BAD_TOPIC");
    public static final ErrorCode TTV_EC_PUBSUB_BAD_MESSAGE = new CoreErrorCode(0x54, "TTV_EC_PUBSUB_BAD_MESSAGE");
    public static final ErrorCode TTV_EC_PUBSUB_SERVER_INTERNAL_ERROR =
        new CoreErrorCode(0x55, "TTV_EC_PUBSUB_SERVER_INTERNAL_ERROR");
    public static final ErrorCode TTV_EC_PUBSUB_RESPONSE_ERROR =
        new CoreErrorCode(0x56, "TTV_EC_PUBSUB_RESPONSE_ERROR");
    public static final ErrorCode TTV_EC_PROFILEIMAGE_IMAGE_VALIDATION_FAILED =
        new CoreErrorCode(0x57, "TTV_EC_PROFILEIMAGE_IMAGE_VALIDATION_FAILED");
    public static final ErrorCode TTV_EC_PROFILEIMAGE_FORMAT_VALIDATION_FAILED =
        new CoreErrorCode(0x58, "TTV_EC_PROFILEIMAGE_FORMAT_VALIDATION_FAILED");
    public static final ErrorCode TTV_EC_PROFILEIMAGE_SIZE_VALIDATION_FAILED =
        new CoreErrorCode(0x59, "TTV_EC_PROFILEIMAGE_SIZE_VALIDATION_FAILED");
    public static final ErrorCode TTV_EC_PROFILEIMAGE_BACKEND_FAILURE =
        new CoreErrorCode(0x5a, "TTV_EC_PROFILEIMAGE_BACKEND_FAILURE");
    public static final ErrorCode TTV_EC_GRAPHQL_ERROR = new CoreErrorCode(0x5b, "TTV_EC_GRAPHQL_ERROR");
    public static final ErrorCode TTV_EC_INVALID_GRAPHQL = new CoreErrorCode(0x5c, "TTV_EC_INVALID_GRAPHQL");
    public static final ErrorCode TTV_EC_INVALID_STRUCT_SIZE = new CoreErrorCode(0x5d, "TTV_EC_INVALID_STRUCT_SIZE");
    public static final ErrorCode TTV_EC_REQUEST_ABORTED = new CoreErrorCode(0x5e, "TTV_EC_REQUEST_ABORTED");
    public static final ErrorCode TTV_EC_STILL_IN_USE = new CoreErrorCode(0x5f, "TTV_EC_STILL_IN_USE");
    public static final ErrorCode TTV_EC_END_ERRORS = new CoreErrorCode(0x60, "TTV_EC_END_ERRORS");
    // BINDING_ENUM_END (Do not remove this line, it's used by the bindings tools)

    private CoreErrorCode(int value, String name) { super(value, name); }
}
