package tv.twitch;

public class ErrorResult<ResultType> extends tv.twitch.Result<ResultType> {
    public ErrorResult(ErrorCode errorCode) { mErrorCode = errorCode; }

    @Override
    public boolean isSuccess() {
        return false;
    }

    @Override
    public boolean isError() {
        return true;
    }

    @Override
    public ErrorCode getErrorCode() {
        return mErrorCode;
    }

    @Override
    public ResultType getResult() {
        return null;
    }

    private ErrorCode mErrorCode;
}
