package tv.twitch;

/**
 * Checks the current thread for proper thread isolation.
 * Only one thread may call a JNI method at a time.
 * The SDK calls {@link #beforeJni()} before all JNI method calls
 * and {@link #afterJni()} after all JNI method calls. If {@link #beforeJni()}
 * throws an Exception, then the SDK will not call JNI, and thus
 * {@link #afterJni()} will not be called.
 *
 * For a simple main-thread-only implementation, see {@link MainJniThreadChecker}.
 * For a simple single-thread-only implementation, see {@link SingleJniThreadChecker}.
 * </code>
 */
public interface IJniThreadChecker {
    /**
     * The SDK calls this method before calling any JNI method.
     */
    void beforeJni();

    /**
     * The SDK calls this method after calling any JNI method.
     */
    void afterJni();
}
