package tv.twitch;

/**
 * Only two implementations should exist:
 * {@link PassThroughJniThreadValidator} does nothing.
 * {@link JniThreadValidator} guarantees that the SDK only calls {@link IJniThreadChecker#afterJni()}
 * if {@link IJniThreadChecker#beforeJni()} succeeds.
 */
public interface IJniThreadValidator {
    void callJniRunnable(Runnable jniRunnable);

    <V> V callJniCallable(IJniCallable<V> jniCallable);
}
