package tv.twitch;

public interface ISocket {
    ErrorCode connect();
    ErrorCode disconnect();

    ErrorCode send(byte[] buffer, int count, ResultContainer<Integer> sent);
    ErrorCode recv(byte[] buffer, int count, ResultContainer<Integer> received);
    ErrorCode flushCache();

    int totalSent();
    int totalReceived();

    boolean connected();
}
