package tv.twitch;

/**
 * Guarantees that the SDK only calls {@link IJniThreadChecker#afterJni()}
 * if {@link IJniThreadChecker#beforeJni()} succeeds.
 */
public final class JniThreadValidator implements IJniThreadValidator {
    private final IJniThreadChecker mJniThreadChecker;

    public JniThreadValidator(IJniThreadChecker jniThreadChecker) {
        if (jniThreadChecker == null) {
            throw new IllegalArgumentException("jniThreadChecker must not be null");
        }
        mJniThreadChecker = jniThreadChecker;
    }

    @Override
    public void callJniRunnable(Runnable jniRunnable) {
        mJniThreadChecker.beforeJni();
        try {
            jniRunnable.run();
        } finally {
            mJniThreadChecker.afterJni();
        }
    }

    @Override
    public <V> V callJniCallable(IJniCallable<V> jniCallable) {
        mJniThreadChecker.beforeJni();
        try {
            return jniCallable.call();
        } finally {
            mJniThreadChecker.afterJni();
        }
    }
}
