package tv.twitch;

/**
 * Checks that only the given main thread calls SDK JNI methods
 */
public final class MainJniThreadChecker implements IJniThreadChecker {
    private final Thread mainThread;

    public MainJniThreadChecker(Thread mainThread) {
        if (mainThread == null) {
            throw new IllegalArgumentException("mainThread must not be null");
        }
        this.mainThread = mainThread;
    }

    @Override
    public void beforeJni() {
        final Thread currentThread = Thread.currentThread();
        if (mainThread != currentThread) {
            throw new IllegalStateException("SDK JNI calls should only happen on " + mainThread
                + " and you tried to call another on " + currentThread);
        }
    }

    @Override
    public void afterJni() {}
}
