package tv.twitch;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum MessageLevel {
    // BINDING_ENUM_START (Do not remove this line, it's used by the bindings tools)
    TTV_ML_DEBUG(0),
    TTV_ML_INFO(1),
    TTV_ML_WARNING(2),
    TTV_ML_ERROR(3),
    TTV_ML_NONE(4);
    // BINDING_ENUM_END (Do not remove this line, it's used by the bindings tools)

    private static Map<Integer, MessageLevel> s_Map = new HashMap<Integer, MessageLevel>();

    static {
        EnumSet<MessageLevel> set = EnumSet.allOf(MessageLevel.class);

        for (MessageLevel e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static MessageLevel lookupValue(int val) {
        MessageLevel err = s_Map.get(val);
        return err;
    }

    private int m_Value;

    private MessageLevel(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
