package tv.twitch;

public class SuccessResult<ResultType> extends tv.twitch.Result<ResultType> {
    private final ErrorCode TTV_EC_SUCCESS = ErrorCode.lookupName("TTV_EC_SUCCESS");

    public SuccessResult(ResultType result) { mResult = result; }

    @Override
    public boolean isSuccess() {
        return true;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public ErrorCode getErrorCode() {
        return TTV_EC_SUCCESS;
    }

    @Override
    public ResultType getResult() {
        return mResult;
    }

    private ResultType mResult;
}
