package tv.twitch;

/**
 * Task parameters for adding IEventScheduler tasks.
 *   - TaskFunction taskFunction        Required - The task to be added into the IEventScheduler/EventQueue.
 *   - String taskName                  Optional - Name of the task to be used for logging purposes (default is "").
 *   - long delayMilliseconds           Optional - The delay in milliseconds to run the task (default is 0).
 */
public class TaskParams {
    public TaskParams(TaskFunction taskFunction, long delayMilliseconds, String taskName) {
        this.taskFunction = taskFunction;
        this.delayMilliseconds = delayMilliseconds;
        this.taskName = taskName;
    }

    public TaskParams(TaskFunction taskFunction, String taskName) { this(taskFunction, 0, taskName); }

    public TaskParams(TaskFunction taskFunction, long delayMilliseconds) {
        this(taskFunction, delayMilliseconds, null);
    }

    public TaskParams(TaskFunction taskFunction) { this(taskFunction, 0, null); }

    public TaskFunction taskFunction;
    public String taskName;
    public long delayMilliseconds;
}
