package tv.twitch;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum WebSocketMessageType {
    // BINDING_ENUM_START (Do not remove this line, it's used by the bindings tools)
    None(0),
    Binary(1),
    Text(2),
    Unknown(3);
    // BINDING_ENUM_END (Do not remove this line, it's used by the bindings tools)

    private static Map<Integer, WebSocketMessageType> s_Map = new HashMap<Integer, WebSocketMessageType>();

    static {
        EnumSet<WebSocketMessageType> set = EnumSet.allOf(WebSocketMessageType.class);

        for (WebSocketMessageType e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static WebSocketMessageType lookupValue(int val) {
        WebSocketMessageType err = s_Map.get(val);

        if (err == null) {
            System.err.println("WebSocketMessageType not found: " + val);
        }

        return err;
    }

    private int m_Value;

    private WebSocketMessageType(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
