/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include <jni.h>
#include <unordered_map>

#include <string>

namespace ttv {
namespace binding {
namespace java {
struct JavaClassInfo {
  jclass klass;
  std::unordered_map<std::string, jmethodID> methods;
  std::unordered_map<std::string, jmethodID> staticMethods;
  std::unordered_map<std::string, jfieldID> fields;
};

bool LookupJavaClass(JNIEnv* jEnv, JavaClassInfo& info, const char* klass);
bool LookupJavaMethod(JNIEnv* jEnv, JavaClassInfo& info, const char* method, const char* signature);
bool LookupJavaStaticMethod(JNIEnv* jEnv, JavaClassInfo& info, const char* method, const char* signature);
bool LookupJavaField(JNIEnv* jEnv, JavaClassInfo& info, const char* field, const char* signature);
}  // namespace java
}  // namespace binding
}  // namespace ttv
