/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/httprequest.h"
#include "twitchsdk/core/java_utility.h"

namespace ttv {
namespace binding {
namespace java {
class JavaHttpRequest;
}
}  // namespace binding
}  // namespace ttv

class ttv::binding::java::JavaHttpRequest : public HttpRequest {
 public:
  JavaHttpRequest(JNIEnv* jEnv, jobject jObject);

  virtual TTV_ErrorCode SendHttpRequest(const std::string& requestName, const std::string& url,
    const std::vector<HttpParam>& requestHeaders, const uint8_t* requestBody, size_t requestBodySize,
    HttpRequestType httpReqType, uint timeOutInSecs, HttpRequestHeadersCallback headersCallback,
    HttpRequestCallback responseCallback, void* userData) override;

 private:
  GlobalJavaObjectReference mJavaInstance;
};
