/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/generated/java_errorcode.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ErrorCode(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/ErrorCode");

        LookupJavaMethod(jEnv, info, "<init>", "(ILjava/lang/String;)V"); // protected tv.twitch.ErrorCode(int, java.lang.String);

        LookupJavaStaticMethod(jEnv, info, "lookupValue", "(I)Ltv/twitch/ErrorCode;"); // public static tv.twitch.ErrorCode lookupValue(int);
        LookupJavaStaticMethod(jEnv, info, "lookupName", "(Ljava/lang/String;)Ltv/twitch/ErrorCode;"); // public static tv.twitch.ErrorCode lookupName(java.lang.String);

        LookupJavaMethod(jEnv, info, "getValue", "()I"); // public int getValue();
        LookupJavaMethod(jEnv, info, "getName", "()Ljava/lang/String;"); // public java.lang.String getName();
        LookupJavaMethod(jEnv, info, "succeeded", "()Z"); // public boolean succeeded();
        LookupJavaMethod(jEnv, info, "failed", "()Z"); // public boolean failed();
        LookupJavaMethod(jEnv, info, "equals", "(Ljava/lang/Object;)Z"); // public boolean equals(java.lang.Object);
        LookupJavaMethod(jEnv, info, "hashCode", "()I"); // public int hashCode();

    }

    return info;
}
