/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/generated/java_ihttprequestprovider.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_IHttpRequestProvider(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/IHttpRequestProvider");

        LookupJavaMethod(jEnv, info, "sendHttpRequest", "(Ljava/lang/String;Ljava/lang/String;[Ltv/twitch/HttpParameter;[BLjava/lang/String;ILtv/twitch/HttpRequestResult;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode sendHttpRequest(java.lang.String, java.lang.String, tv.twitch.HttpParameter[], byte[], java.lang.String, int, tv.twitch.HttpRequestResult);
    }

    return info;
}
