/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/generated/java_isocket.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ISocket(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/ISocket");

        LookupJavaMethod(jEnv, info, "connect", "()Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode connect();
        LookupJavaMethod(jEnv, info, "disconnect", "()Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode disconnect();
        LookupJavaMethod(jEnv, info, "send", "([BILtv/twitch/ResultContainer;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode send(byte[], int, tv.twitch.ResultContainer<java.lang.Integer>);
        LookupJavaMethod(jEnv, info, "recv", "([BILtv/twitch/ResultContainer;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode recv(byte[], int, tv.twitch.ResultContainer<java.lang.Integer>);
        LookupJavaMethod(jEnv, info, "flushCache", "()Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode flushCache();
        LookupJavaMethod(jEnv, info, "totalSent", "()I"); // public abstract int totalSent();
        LookupJavaMethod(jEnv, info, "totalReceived", "()I"); // public abstract int totalReceived();
        LookupJavaMethod(jEnv, info, "connected", "()Z"); // public abstract boolean connected();
    }

    return info;
}
