/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/generated/java_isocketfactory.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ISocketFactory(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/ISocketFactory");

        LookupJavaMethod(jEnv, info, "isProtocolSupported", "(Ljava/lang/String;)Z"); // public abstract boolean isProtocolSupported(java.lang.String);
        LookupJavaMethod(jEnv, info, "createSocket", "(Ljava/lang/String;Ltv/twitch/ResultContainer;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode createSocket(java.lang.String, tv.twitch.ResultContainer<tv.twitch.ISocket>);
    }

    return info;
}
