/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/generated/java_iwebsocket.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_IWebSocket(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/IWebSocket");

        LookupJavaMethod(jEnv, info, "connect", "()Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode connect();
        LookupJavaMethod(jEnv, info, "disconnect", "()Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode disconnect();
        LookupJavaMethod(jEnv, info, "send", "(Ltv/twitch/WebSocketMessageType;[BI)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode send(tv.twitch.WebSocketMessageType, byte[], int);
        LookupJavaMethod(jEnv, info, "recv", "(Ltv/twitch/ResultContainer;[BILtv/twitch/ResultContainer;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode recv(tv.twitch.ResultContainer<tv.twitch.WebSocketMessageType>, byte[], int, tv.twitch.ResultContainer<java.lang.Integer>);
        LookupJavaMethod(jEnv, info, "peek", "(Ltv/twitch/ResultContainer;Ltv/twitch/ResultContainer;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode peek(tv.twitch.ResultContainer<tv.twitch.WebSocketMessageType>, tv.twitch.ResultContainer<java.lang.Integer>);
        LookupJavaMethod(jEnv, info, "connected", "()Z"); // public abstract boolean connected();
    }

    return info;
}
