/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/generated/java_messagelevel.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_MessageLevel(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/MessageLevel");

        LookupJavaStaticMethod(jEnv, info, "lookupValue", "(I)Ltv/twitch/MessageLevel;"); // public static tv.twitch.MessageLevel lookupValue(int);
        LookupJavaStaticMethod(jEnv, info, "values", "()[Ltv/twitch/MessageLevel;"); // public static tv.twitch.MessageLevel[] values();
        LookupJavaStaticMethod(jEnv, info, "valueOf", "(Ljava/lang/String;)Ltv/twitch/MessageLevel;"); // public static tv.twitch.MessageLevel valueOf(java.lang.String);

        LookupJavaMethod(jEnv, info, "getValue", "()I"); // public int getValue();

    }

    return info;
}
