/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/generated/java_nativeproxy.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_NativeProxy(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/NativeProxy");

        LookupJavaMethod(jEnv, info, "<init>", "(Ltv/twitch/IJniThreadValidator;)V"); // protected tv.twitch.NativeProxy(tv.twitch.IJniThreadValidator);
        LookupJavaMethod(jEnv, info, "<init>", "(JLtv/twitch/IJniThreadValidator;)V"); // protected tv.twitch.NativeProxy(long, tv.twitch.IJniThreadValidator);

        LookupJavaMethod(jEnv, info, "createNativeInstance", "()J"); // protected long createNativeInstance();
        LookupJavaMethod(jEnv, info, "disposeNativeInstance", "(J)V"); // protected abstract void disposeNativeInstance(long);
        LookupJavaMethod(jEnv, info, "getNativeObjectPointer", "()J"); // protected long getNativeObjectPointer();
        LookupJavaMethod(jEnv, info, "finalize", "()V"); // protected void finalize() throws java.lang.Throwable;
        LookupJavaMethod(jEnv, info, "dispose", "()V"); // public void dispose();
    }

    return info;
}
