/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/generated/java_result.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_Result(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/Result");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.Result();

        LookupJavaMethod(jEnv, info, "isSuccess", "()Z"); // public abstract boolean isSuccess();
        LookupJavaMethod(jEnv, info, "isError", "()Z"); // public abstract boolean isError();
        LookupJavaMethod(jEnv, info, "getErrorCode", "()Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode getErrorCode();
        LookupJavaMethod(jEnv, info, "getResult", "()Ljava/lang/Object;"); // public abstract ResultType getResult();
    }

    return info;
}
