/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/generated/java_successresult.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_SuccessResult(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/SuccessResult");

        LookupJavaMethod(jEnv, info, "<init>", "(Ljava/lang/Object;)V"); // public tv.twitch.SuccessResult(ResultType);

        LookupJavaMethod(jEnv, info, "isSuccess", "()Z"); // public boolean isSuccess();
        LookupJavaMethod(jEnv, info, "isError", "()Z"); // public boolean isError();
        LookupJavaMethod(jEnv, info, "getErrorCode", "()Ltv/twitch/ErrorCode;"); // public tv.twitch.ErrorCode getErrorCode();
        LookupJavaMethod(jEnv, info, "getResult", "()Ljava/lang/Object;"); // public ResultType getResult();
    }

    return info;
}
