/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/generated/java_taskparams.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_TaskParams(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/TaskParams");

        LookupJavaMethod(jEnv, info, "<init>", "(Ltv/twitch/TaskFunction;JLjava/lang/String;)V"); // public tv.twitch.TaskParams(tv.twitch.TaskFunction, long, java.lang.String);
        LookupJavaMethod(jEnv, info, "<init>", "(Ltv/twitch/TaskFunction;Ljava/lang/String;)V"); // public tv.twitch.TaskParams(tv.twitch.TaskFunction, java.lang.String);
        LookupJavaMethod(jEnv, info, "<init>", "(Ltv/twitch/TaskFunction;J)V"); // public tv.twitch.TaskParams(tv.twitch.TaskFunction, long);
        LookupJavaMethod(jEnv, info, "<init>", "(Ltv/twitch/TaskFunction;)V"); // public tv.twitch.TaskParams(tv.twitch.TaskFunction);

        LookupJavaField(jEnv, info, "taskFunction", "Ltv/twitch/TaskFunction;"); // public tv.twitch.TaskFunction taskFunction;
        LookupJavaField(jEnv, info, "taskName", "Ljava/lang/String;"); // public java.lang.String taskName;
        LookupJavaField(jEnv, info, "delayMilliseconds", "J"); // public long delayMilliseconds;
    }

    return info;
}
