# core_orbis

## Overview
```core_orbis``` implements PS4-specific primitives that are built upon native PS4 libraries as described at https://ps4.siedev.net/.

## Environment Setup
Currently development on the PS4 can only be done on Windows, and you'll need to have access to the ```apps/universal_viewer``` repo in order to build and test ```core_orbis```.

Follow the setup described in [universal_viewer: Environment Setup](https://git.xarth.tv/apps/universal_viewer/wiki/Environment-Setup)
* [General Setup (Windows)](https://git.xarth.tv/apps/universal_viewer/wiki/Environment-Setup#general-setup-windows)
  * You should be able to skip this if you've previously built the sdk on Windows in the past
* [Setting up for PS4 development (Windows)](https://git.xarth.tv/apps/universal_viewer/wiki/Environment-Setup#setting-up-for-ps4-development-windows)
  * Follow the steps described above
  * [The PS4 getting started guide](https://ps4.siedev.net/resources/documents/SDK/4.500/Getting_Started_Guide/0001.html) is helpful if you're hitting issues.
  * ```sdk``` lives as a submodule in ```universal_viewer```
    * Be sure to make sure your submodules are up to date (git submodule init / git submodule update)
	* It's probably easiest to make your changes for ```sdk``` in the submodule itself (within the larger ```universal_viewer``` repo).

## Project Generation
We have some scripts to generate projects that are targeted for the PS4.
In general, follow the steps described in [Building the Application: Playstation 4](https://git.xarth.tv/apps/universal_viewer/wiki/Building-the-Application#playstation-4).
* You'll need to navigate to the ```universal_viewer\application\build\ps4``` directory to build
* ```TwitchApp.sln``` is a VS solution that will reference the files in ```core_orbis``` and allow us to test/build the PS4 app.

## Project Generation Example
Default in ```universal_viewer\application\build\ps4\generate_twitchsdk.cmd```:

```
python generate_twitchsdk.py --cmake-no-generate --static --module=chat --module=social --module=tracking --module=experiment --module=ads --platform=orbis --compiler=vs2015 --arch=x64 --output-dir=%OUTPUT_ROOT_DIR% --project-name=%PROJECT_NAME% --root-dir=%TWITCHSDK_INTERNAL_DIR% -settings TTV_USE_ORBIS_RAW_SOCKET TTV_USE_STD_WEBSOCKET
```

To build the app without relying on youiengine for primitives:
```
python generate_twitchsdk.py --cmake-no-generate --static --module=chat --module=social --module=tracking --module=experiment --module=ads --platform=orbis --compiler=vs2015 --arch=x64 --output-dir=%OUTPUT_ROOT_DIR% --project-name=%PROJECT_NAME% --root-dir=%TWITCHSDK_INTERNAL_DIR% -settings TTV_USE_ORBIS_RAW_SOCKET TTV_USE_ORBIS_HTTPREQUEST TTV_USE_STD_WEBSOCKET TTV_USE_STD_MUTEX TTV_USE_STD_THREAD TTV_USE_STD_SYSTEM_CLOCK TTV_USE_STD_THREAD_SYNC TTV_USE_STD_THREAD_API TTV_USE_STD_TRACER
```

The settings switches at the end of the ```generate_twitchsdk.py``` command can be modified to use different primitive implementations.

Here are the PS4 specific primitives:

|             Switch                        |  Meaning  |
|-------------------------------------------|-----------|
| TTV_USE_ORBIS_RAW_SOCKET    |  Pulls in the PS4 socket implementation in ```sdk/modules/core/core_orbis/source/orbissocket.cpp```   |
| TTV_USE_ORBIS_HTTPREQUEST |  Pull in the PS4 httprequest implementation in ```sdk/modules/core/core_orbis/source/orbishttprequest.cpp``` |
| TTV_USE_ORBIS_RANDOM | Pull in the PS4 random implementation in ```sdk/modules/core/core_orbis/source/random.cpp``` |

Note: If you modify any of these switches, be sure to re-run ```generate_twitchsdk.cmd``` and ```Generate.bat```.

You may also need to change ```universal_viewer\application\src\source\twitchapp\common\twitchsdk\twitchsdkmanager.cpp``` to reflect the primitives you're pulling in with ```generate_twitchsdk.py```. Additionally, ```universal_viewer\application\build\ps4\twitchsdk\twitchsdk.cpp``` will be auto-generated with switch changes as well.
