##########################################################################################################
#
# Fragment: twitchcore_orbis 
#
# See README.md for fragment documentation.
# 
##########################################################################################################

import glob
import os
import build_types

def load_twitchsdk_fragment(primitives, options):

    fragment = build_types.SourceFragment('twitchsdk', 'core_orbis', os.path.dirname(os.path.realpath(__file__)))

    # Pull in primitives
    use_all_implementations = options.has_setting('TWITCH_USE_ALL_ORBIS_IMPLEMENTATIONS')

    # Preprocessor defines
    if not primitives.implemented('MEMORY'):
        fragment.add_source_files( os.path.join(fragment.root_path, "source/orbismemory.cpp") )
        primitives.set('MEMORY', None)

    if not primitives.implemented('ASSERT'):
        fragment.add_source_files( os.path.join(fragment.root_path, "source/orbisassert.cpp") )
        primitives.set('ASSERT', None)

    if not primitives.implemented('RANDOM'):
        fragment.add_source_files( os.path.join(fragment.root_path, "source/orbisrandom.cpp") )
        primitives.set('RANDOM', None)

    if use_all_implementations or options.has_setting('TTV_USE_ORBIS_RAW_SOCKET'):
        fragment.add_source_files( os.path.join(fragment.root_path, "source/orbissocket.cpp") )
        fragment.add_header_files( os.path.join(fragment.root_path, "include/twitchsdk/core/orbissocket.h") )

        if not primitives.implemented('RAW_SOCKET_FACTORY'):
            primitives.set('RAW_SOCKET_FACTORY', "ttv::OrbisSocketFactory", "twitchsdk/core/orbissocket.h")

    if use_all_implementations or options.has_setting('TTV_USE_ORBIS_HTTPREQUEST'):
        fragment.add_source_files( os.path.join(fragment.root_path, "source/orbishttprequest.cpp") )
        fragment.add_header_files( os.path.join(fragment.root_path, "include/twitchsdk/core/orbishttprequest.h") )

        if not primitives.implemented('HTTP_REQUEST'):
            primitives.set('HTTP_REQUEST', "ttv::OrbisHttpRequest", "twitchsdk/core/orbishttprequest.h")

    fragment.add_source_group("Source Files/core/orbis", fragment.source_files)
    fragment.add_source_group("Header Files/core/orbis", fragment.header_files)

    # Include paths
    fragment.add_header_search_paths( os.path.join(fragment.root_path, 'include') )

    return fragment
