/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once
#include "twitchsdk/core/socket.h"

namespace ttv {
class OrbisSocket;
class OrbisSocketFactory;
}  // namespace ttv

class ttv::OrbisSocket : public ISocket {
 public:
  OrbisSocket(const std::string& host, uint32_t port);
  virtual ~OrbisSocket();

  // ISocket Implementation
  virtual TTV_ErrorCode Connect();
  virtual TTV_ErrorCode Disconnect();
  virtual TTV_ErrorCode Send(const uint8_t* buffer, size_t length, size_t& sent);
  virtual TTV_ErrorCode Recv(uint8_t* buffer, size_t length, size_t& received);
  virtual uint64_t TotalSent();
  virtual uint64_t TotalReceived();
  virtual bool Connected();

 private:
  TTV_ErrorCode SetBlockingMode(bool block);

  std::string mHostName;
  std::string mPort;
  uint64_t mTotalRecieved;
  uint64_t mTotalSent;
  uint32_t mSocket;
  int mCachePos;
  int mLastSocketError;
};

class ttv::OrbisSocketFactory : public ttv::ISocketFactory {
 public:
  virtual bool IsProtocolSupported(const std::string& protocol) override;
  virtual TTV_ErrorCode CreateSocket(const std::string& uri, std::shared_ptr<ISocket>& result) override;
};
