/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

#include <string>

namespace ttv {
namespace assertion {
void PlatformAssert(const char* expr, const char* component, const char* message, const char* file, int line);
}
}  // namespace ttv

void ttv::assertion::PlatformAssert(
  const char* expr, const char* component, const char* message, const char* file, int line) {
#if _DEBUG
  std::string info = std::string() + "[expr] " + expr + " [component] " + component + " [message] " + message;
  std::string loc = std::string() + "[file] " + file + " [line] " + std::to_string(line);

  _Assert(info.c_str(), loc.c_str());
#else
  (void)expr;
#endif
}
