# core_std

## Overview
* Implements standard library-specific primitive and service support.
* This fragment is usually pulled in piecemeal on each platform.
* There is not a default implementation of all services available in this fragment.

## Custom Switches
|             Switch                        |  Meaning  |
|-------------------------------------------|-----------|
| TTV_USE_STD_MUTEX    |  Pulls in StandardMutex and StandardMutexFactory and registers it as the mutex factory if none is already registered. |
| TTV_USE_STD_RAW_SOCKET |  Pulls in StandardSocket and StandardSocketFactory and registers it as the "raw"/"tls" socket factory if none is already registered. |
| TTV_USE_STD_WEBSOCKET |  Pulls in WebSocket and WebSocketFactory and registers it as the "ws" socket factory if none is already registered. |
| TTV_USE_STD_FILE_SOCKET |  Pulls in FileSocket but does not register it. |
| TTV_USE_STD_OPENSSL_SOCKET |  Pulls in OpenSSLSocket and registers it as the "tls" socket factory if none is already registered. |
| TTV_USE_STD_SYSTEM_CLOCK |  Pulls in StandardSystemClock and registers it if none is already registered. |
| TTV_USE_STD_THREAD | Pulls in StandardThread and StandardThreadFactory and registers it if none is already registered.  |
| TTV_USE_STD_THREAD_API | Pulls in StandardThreadApi and registers it if none is already registered.  |
| TTV_USE_STD_THREAD_SYNC | Pulls in StandardThreadSync and StandardThreadSyncFactory and registers it if none is already registered.  |
| TTV_USE_STD_BACKGROUND_EVENT_SCHEDULER | Pulls in ThreadedEventSchedulerFactory and registers it if none is already registered.  |
| TTV_USE_STD_TRACER | Pulls in StandardTracer and registers it if none is already registered.  |
