/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/socket.h"

namespace ttv {
class StandardFileSocket;
class StandardFileSocketFactory;
}  // namespace ttv

class ttv::StandardFileSocket : public ISocket {
 public:
  StandardFileSocket();
  virtual ~StandardFileSocket();

  TTV_ErrorCode Initialize(const std::string& inputPath, const std::string& outputPath);

  // ISocket Implementation
  virtual TTV_ErrorCode Connect();
  virtual TTV_ErrorCode Disconnect();
  virtual TTV_ErrorCode Send(const uint8_t* buffer, size_t length, size_t& sent);
  virtual TTV_ErrorCode Recv(uint8_t* buffer, size_t length, size_t& received);
  virtual uint64_t TotalSent();
  virtual uint64_t TotalReceived();
  virtual bool Connected();

 private:
  std::string mInputFilePath;
  std::string mOutputFilePath;
  FILE* mInputFile;
  FILE* mOutputFile;
  uint64_t mTotalSent;
  uint64_t mTotalRecieved;
  bool mConnected;
};

class ttv::StandardFileSocketFactory : public ttv::ISocketFactory {
 public:
  virtual ~StandardFileSocketFactory();

  virtual bool IsProtocolSupported(const std::string& protocol);
  virtual TTV_ErrorCode CreateSocket(const std::string& uri, std::shared_ptr<ISocket>& result);
};
