/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/thread.h"
#include "twitchsdk/core/types/coretypes.h"
#include "twitchsdk/core/types/errortypes.h"

#include <thread>

namespace ttv {
class StandardThread;
class StandardThreadFactory;
}  // namespace ttv

class ttv::StandardThread : public IThread {
 public:
  StandardThread(ThreadProc threadProc, const std::string& name);
  ~StandardThread();

  virtual void Run();
  virtual bool Joinable() const;
  virtual void Join();

 private:
  ThreadProc mThreadProc;
  std::string mName;
  std::unique_ptr<std::thread> mThread;
};

class ttv::StandardThreadFactory : public ttv::IThreadFactory {
 public:
  virtual ~StandardThreadFactory();
  virtual TTV_ErrorCode CreateThread(ThreadProc threadProc, const std::string& name, std::shared_ptr<IThread>& result);
};
