/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/httprequestutils.h"
#include "twitchsdk/core/socket.h"

namespace ttv {
class StandardWebSocket;
class StandardWebSocketFactory;
struct StandardWebSocketInnerData;
}  // namespace ttv

class ttv::StandardWebSocket : public IWebSocket {
 public:
  StandardWebSocket();
  virtual ~StandardWebSocket() override;

  TTV_ErrorCode Initialize(const std::string& uri);

  // IWebSocket Implementation
  virtual TTV_ErrorCode Connect() override;
  virtual TTV_ErrorCode Disconnect() override;
  virtual bool Connected() override;
  virtual TTV_ErrorCode Send(MessageType type, const uint8_t* buffer, size_t length) override;
  virtual TTV_ErrorCode Recv(MessageType& type, uint8_t* buffer, size_t length, size_t& received) override;
  virtual TTV_ErrorCode Peek(MessageType& type, size_t& length) override;

 private:
  struct SocketData;

  TTV_ErrorCode PollBaseSocket();

  std::unique_ptr<SocketData> mInnerData;
};

class ttv::StandardWebSocketFactory : public ttv::IWebSocketFactory {
 public:
  virtual ~StandardWebSocketFactory();
  virtual bool IsProtocolSupported(const std::string& protocol);
  virtual TTV_ErrorCode CreateWebSocket(const std::string& uri, std::shared_ptr<IWebSocket>& result);
};
