/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

namespace ttv {
namespace assertion {
#ifndef NDEBUG
_LIBCPP_NORETURN void PlatformAssert(
  const char* expr, const char* component, const char* message, const char* file, int line);
#else
void PlatformAssert(const char* expr, const char* component, const char* message, const char* file, int line);
#endif
}  // namespace assertion
}  // namespace ttv

void ttv::assertion::PlatformAssert(
  const char* expr, const char* /*component*/, const char* /*message*/, const char* file, int line) {
  // glibc seems to consistently have __assert, even if it uses something else.
#ifndef NDEBUG
  __assert(expr, file, line);
#endif
}
