/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

#include "twitchsdk/core/memory.h"

#include <stdlib.h>

namespace ttv {
extern TTV_AllocCallback gAllocCallback;
extern TTV_FreeCallback gFreeCallback;

void* DefaultAlignedMalloc(size_t size, size_t alignment);
void DefaultAlignedFree(void* p);

void* DefaultAlignedMalloc(size_t size, size_t alignment) {
  void* ptr = nullptr;
  int ret = posix_memalign(&ptr, alignment, size);
  if (ret != 0) {
    ptr = nullptr;
  }
  return ptr;
}

void DefaultAlignedFree(void* p) {
  free(p);
}
}  // namespace ttv

#if TTV_DYNAMIC_LIBRARY

void* operator new(size_t size) {
  TTV_ASSERT(ttv::gAllocCallback);

#ifdef _M_X64
  const size_t alignment = 16;
#else
  const size_t alignment = 0;
#endif
  return ttv::gAllocCallback(size, alignment);
}

void* operator new[](size_t size) {
  return operator new(size);
}

void operator delete(void* p) {
  TTV_ASSERT(ttv::gFreeCallback);

  ttv::gFreeCallback(p);
}

void operator delete[](void* p) {
  delete (p);
}

#endif
