/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

#include "twitchsdk/core/random.h"

namespace ttv {
namespace random {

namespace {
class ThreadSafeStandardGenerator : public ttv::random::IGenerator {
 public:
  ThreadSafeStandardGenerator() = default;
  ~ThreadSafeStandardGenerator() = default;

  virtual result_type operator()() final {
    // We want to ensure that only one generator exists per thread.  This
    // will create a new Generator object anytime a unique thread calls this
    // method.
    static thread_local auto engine(CreatePlatformRandomEngine());
    return engine();
  }

 private:
  std::default_random_engine CreatePlatformRandomEngine() {
    std::random_device device;
    std::default_random_engine generator(device());

    return generator;
  }
};
}  // namespace

IGenerator& GetGenerator() {
  static ThreadSafeStandardGenerator engine;
  return engine;
}

}  // namespace random
}  // namespace ttv
